import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.business.BusinessEntity;
import org.uddi4j.response.BusinessDetail;
import org.uddi4j.transport.TransportFactory;
import java.util.Vector;

public class UDDIGetBusinessDetail1 {

	public static void main(String[] args) throws Exception {

		System.setProperty(TransportFactory.PROPERTY_NAME, "org.uddi4j.transport.ApacheAxisTransport");

		UDDIProxy proxy = new UDDIProxy();
		proxy.setInquiryURL("http://uddi.microsoft.com/inquire");

		BusinessDetail bd = proxy.get_businessDetail("D2033110-3AAF-11D5-80DC-002035229C64");

		Vector bev = bd.getBusinessEntityVector();
		if (bev.size() == 0) {
			System.out.println("no business(es) found");
			System.exit(0);
		}

		System.out.println(bev.size()+" business(es) found\n");
		for (int i = 0; i < bev.size(); i++) {
			BusinessEntity be = (BusinessEntity)bev.elementAt(i);
			System.out.println(be.getDefaultNameString());
			System.out.println(be.getBusinessKey());
			System.out.println("\n");
		}
	}
}